Attribute VB_Name = "modGlobals"
Public Const vDbConn As Variant = "DSN=Eshop;UID=sa;PWD=;"
    

Public Sub Trace(vMsg As Variant)

    Open "c:\eshop.txt" For Append Shared As #1
    Print #1, Time & " " & vMsg
    Close #1
      
End Sub

Public Function RaiseError(ByVal vName As Variant) As Variant
    Dim vErrorInfo As Variant
    Dim vResponse As Collection
    
    vErrorInfo = "Eshop System Failure: " & Hex(Err.Number) & " " & Err.Source & "->" & vName & " " & Err.Description
    
    Err.Clear
    
    Set vResponse = New Collection
    vResponse.Add True, Key:="error"
    vResponse.Add vErrorInfo, Key:="errorinfo"
    
    Trace (vErrorInfo)
    
    Set RaiseError = vResponse
    
End Function

Public Function AdjustTodaysPrice(ByVal vPrice As Variant, ByVal vPromotionCode As Variant, ByVal vPromotionEndDate As Variant) As Variant
    Dim vTodaysPrice As Variant
    
    If DateDiff("d", Now, vPromotionEndDate) < 0 Then
        vTodaysPrice = vPrice
    Else
        Select Case vPromotionCode
        Case "A"
            vTodaysPrice = vPrice * 0.95
        Case "B"
            vTodaysPrice = vPrice * 0.9
        Case "C"
            vTodaysPrice = vPrice * 0.85
        Case "D"
            vTodaysPrice = vPrice * 0.8
        Case "E"
            vTodaysPrice = vPrice * 0.75
        Case Else
            vTodaysPrice = vPrice
        End Select
    End If

    AdjustTodaysPrice = vTodaysPrice

End Function

Public Function GetInterestName(ByVal vCode As Variant) As Variant
    Dim vRet As Variant
    
    Select Case vCode
    Case "B"
        vRet = "VB"
    Case "C"
        vRet = "VC++"
    Case "J"
        vRet = "Java"
    Case "I"
        vRet = "Internet"
    Case "O"
        vRet = "Other"
    End Select
    
    GetInterestName = vRet
    
End Function
 


Public Function BuildInterests(ByVal vSelected As Variant) As Variant
 
    Dim vInterestCodes As Variant
    Dim vInterests As Collection
    Dim vInterest As Collection
    Dim i
    
    vInterestCodes = Array("B", "C", "J", "I", "O")
        
    Set vInterests = New Collection
    
    For i = 0 To 4
        Set vInterest = New Collection
        Trace ("Interest: " & vInterestCodes(i))
        vInterest.Add GetInterestName(vInterestCodes(i)), Key:="name"
        vInterest.Add vInterestCodes(i), Key:="code"
        vInterest.Add InStr(vSelected, vInterestCodes(i)) <> 0, Key:="enabled"
        vInterests.Add vInterest
        Set vInterest = Nothing
    Next i
        
    Trace ("Interests: " & TypeName(vInterests))
        
    Set BuildInterests = vInterests
    Set vInterests = Nothing

End Function

Public Function ExtractInterestCodes(ByVal vInterests As Variant) As Variant

    Dim vInterest As Variant
    Dim vRet As Variant
    vRet = ""
    
    For Each vInterest In vInterests
        If vInterest("enabled") Then
            vRet = vRet & vInterest("code") & ","
        End If
    Next
    vRet = Left(vRet, Len(vRet) - 1)
    ExtractInterestCodes = vRet

End Function
